import csv
import pandas as pd
import numpy as np
import plotly.graph_objects as go
import tkinter as tk
from tkinter import filedialog

root = tk.Tk()
root.withdraw()
root.wm_attributes('-topmost', 1)
foam_data = filedialog.askopenfilename()


plot_type = 'physical3'
with open(foam_data, 'r') as my_foam_data:
    my_data = []
    # x, y, z1, z2 = [], [], [], []
    foam_data = csv.reader(my_foam_data)
    for my_line in foam_data:
        if len(my_line) <= 1 or plot_type not in my_line[0] or int(my_line[4]) < 100:
            continue
        my_data.append({'num': my_line[0], 'avg rad size': float(my_line[2]), 'box size': float(my_line[1]),
                        'rad std': float(my_line[3]), 'num balls': int(my_line[4]),
                        'density': float(my_line[5]), 'vol diff vor': 100 * float(my_line[6]),
                        'sa diff vor': 100 * float(my_line[7]),
                        'vol diff pow': 100 * float(my_line[8]), 'sa diff pow': 100 * float(my_line[9]),
                        'num cells': int(my_line[10])})


lists = {}
for dp in my_data:
    # Check if the data has been added before
    if dp['density'] in lists:
        lists[dp['density']][0].append(dp['vol diff vor'])
        lists[dp['density']][1].append(dp['sa diff vor'])
        # lists[dp['density']][2].append(dp['vol diff pow'])
        # lists[dp['density']][3].append(dp['sa diff pow'])
    else:
        # lists[dp['density']] = [[dp['vol diff vor']], [dp['sa diff vor']], [dp['vol diff pow']],
        #                                        [dp['sa diff pow']]]
        lists[dp['density']] = [[dp['vol diff vor']], [dp['sa diff vor']]]
# for _ in lists:
#     print(_, [len(lists[_][i]) for i in range(4)])

# Calculate averages across sets at each index
averages = [
    [sum(set_values[i]) / len(set_values[i]) for set_values in lists.values()]
    for i in range(len(lists[0.025]))
]
std_errs = [[np.std(set_values[i]) / np.sqrt(len(set_values[i])) for set_values in lists.values()]
            for i in range(len(lists[0.025]))]
print(averages)
print(std_errs)
phys1_avgs_300 = [[37.008617150000006, 45.30689945499999, 57.53305062999999, 62.52562955, 66.510029395, 77.65005144999999, 77.54660364499998, 81.88485556999998, 91.64292164000001, 94.99693345000001, 96.85251543, 110.65964005263159, 113.31046825999996, 116.88841362631581, 118.66423867500001, 128.20859249999998, 132.31003676000003, 131.19261679999997, 131.29891178999998, 145.419068], [29.611066804999997, 32.74879778, 41.53007119499999, 43.158097514999994, 45.36481155500001, 52.229708095, 50.716616314999996, 53.391119665, 58.25506478, 60.455683109999995, 61.69978982, 67.74430823157894, 69.61545457499999, 72.7581465631579, 73.97615180500001, 78.7748815368421, 82.43695034999999, 82.90960420000002, 83.1236302, 90.52213757500002]]
phys1_std_errs_300 = [[0.9345375177779369, 1.2750506825872174, 1.7228053738127354, 1.9116872800237048, 1.2531349766873412, 2.6176541231539163, 1.922668258654939, 2.463660390832947, 3.8086955090383303, 3.1957443689853564, 2.9199055705857804, 4.929661360412729, 5.464711986382739, 3.3993467221525924, 5.054327897047891, 3.9316001287438818, 3.8192567260433514, 4.216916299161461, 4.278030243940548, 4.7621548032398735], [1.091428048215003, 0.8958203063461704, 1.4542790508549144, 1.2507237785831402, 1.1187757080667102, 1.9687871796125291, 1.168336342210556, 1.5633703625526407, 2.320128803946469, 1.823567699055237, 1.4812304780767491, 2.5394703536380097, 2.8483044310800016, 1.742897808736926, 2.4031786640466475, 2.001572590397054, 1.547492734769792, 2.2865238468082736, 2.120846732226859, 2.4487692169716127]]

phys1_avgs_1000 = [[37.008617150000006, 41.86354172210342, 50.301795636982874, 59.49167877005051, 62.00988317833152, 68.33456877801063, 73.1483824862971, 76.7625596321718, 81.60226641395869, 85.17864699869867, 88.15072532164724, 92.59369634339335, 97.3271914336773, 100.35662996977668, 103.40773172002903, 105.04258171652756, 109.69401646543824, 111.13578754925479, 117.51209138531947, 121.61933517587329], [29.611066804999997, 31.269267799370926, 35.411729451122405, 41.68325597752714, 41.750612048403426, 45.371453053850004, 47.5538693351774, 49.94034464388419, 52.388565723330544, 54.42219084286438, 55.161444967002375, 58.639910976468606, 61.86697013118207, 62.98430204670469, 64.65286478693852, 66.0021435589, 68.25352508631326, 70.17759898654876, 73.16360846031262, 76.39481836628995]]
phys1_std_errs_1000 = [[1.0856824341816282, 0.6708073003243473, 0.6469092818931454, 2.439614268337107, 1.0226813497770484, 1.537683290436355, 1.433042972457079, 1.40921920469563, 1.1418528522311637, 1.7094368029088456, 1.1729177119043837, 1.9443910433447198, 1.9621712176906119, 2.0353748182391924, 1.6580454850424484, 1.6841585876330167, 1.2648090599512332, 1.5305232459984095, 2.5402911382161943, 2.5328798116151967], [1.0686184179668043, 0.5294060235268297, 0.5714639304206485, 2.5863924279307935, 0.662536210449189, 0.9822703766698505, 0.7854047330238915, 0.9408153356280274, 0.7880537529831437, 1.2841517728417295, 0.6452852377204221, 1.0349013645541054, 1.2200788000411253, 1.1853391162781863, 0.8634845188691307, 1.0193749301162327, 0.6215926124966973, 0.82277241901945, 1.2899175036811692, 1.432752604035708]]


phys2_avgs_300 =[[26.329342291999996, 33.618983211999996, 33.902872836, 36.252861024000005, 39.678168752000005, 40.29226765200001, 43.23290338000001, 40.85642752000001, 47.321263472, 43.92344234800001, 47.09259588, 50.32392401199999, 55.49221695999999, 49.444227448, 54.888549084000005, 56.56189711600001, 53.12137687599999, 53.274812716, 51.48678286400001, 55.683557627999996], [20.567964392, 25.338966983999995, 24.992621184, 25.666601351999997, 27.804787987999998, 28.33016531200001, 29.47503624799999, 28.487825715999996, 31.995686172, 30.659965004, 32.809248675999996, 34.53699646, 37.967798927999986, 34.533098632, 38.75116378800001, 39.328442288, 37.491514316, 37.848379804000004, 37.17516936, 39.15819948400001]]
phys2_std_errs_300 =[[0.4866042053788794, 1.2390500855102333, 0.8702760082604108, 1.252801524102862, 1.0525894126331545, 1.4854310985990884, 1.5273643232999348, 1.0601302840187607, 1.882483978222492, 1.7113383288525832, 1.268262492099836, 2.026143582852699, 2.3058932516240116, 1.4059092594603126, 3.6257465173182544, 1.715571405389576, 1.9683167439231077, 2.2322793576208975, 0.8953745042555342, 2.207620833867913], [0.5155024982522262, 1.013396767034624, 0.6906278820335039, 0.6845476552225851, 0.6195736868560584, 1.1521159238424832, 0.725592900296556, 0.5999092994113817, 1.0563052926935648, 0.8193834675542983, 0.7802114517657557, 1.1180335207117698, 1.2517492206966574, 0.8214098791741762, 2.4965997277262253, 0.9736158228299286, 1.1178327558417953, 1.1884208331339416, 0.5310178681668971, 1.2057127544364852]]

phys2_avgs_1000 = [[26.329342291999996, 30.68878449212529, 33.29281614550845, 34.84345409265502, 37.39563646509307, 38.61575404273874, 40.43615895250063, 40.29464189266635, 44.423924668339055, 46.006377546387235, 44.37838523637325, 46.77225244522467, 48.22995941656545, 46.42524515174396, 46.95890948606418, 48.85380538046475, 48.47210433500156, 48.317941766717, 48.324199503804714, 48.43540412011133], [20.567964392, 22.764729905340804, 23.81831001363978, 25.172877469773887, 26.333120601311133, 26.959142860636142, 27.82125318092782, 27.833298922538283, 30.856633247799284, 32.20428768694795, 30.495505228809446, 32.147581133814555, 33.13401830699616, 32.36098444226174, 32.704770505904136, 34.0121412707471, 33.980899424633165, 34.05470341639317, 34.3927955455269, 34.569604333738475]]
phys2_std_errs_1000 = [[0.3770398831805324, 0.7392062406855522, 0.3387263448652197, 0.7742598074554968, 0.7028707443759472, 0.4673773035004138, 0.5432225764432795, 0.4962127659485973, 1.2958571296002888, 2.896400923546206, 0.7150090594509454, 0.7420118119335644, 1.2294035802018546, 0.8615856118220252, 0.6872757462186082, 0.7266525066813917, 0.7454050780578716, 1.0904348422007097, 0.7583981375406916, 0.8851386621936267], [0.36311351934967745, 0.6568930549324417, 0.20678200276116815, 0.869669484642518, 0.48244613795725033, 0.2954765381683293, 0.31651742603406197, 0.28503526881734714, 1.2447141533498447, 2.38076250982456, 0.40043482186722223, 0.40828303429569335, 0.7589740110520553, 0.49755161074013166, 0.3797814319169614, 0.3984378056529546, 0.3632490159266054, 0.5939957411366927, 0.41831673427584193, 0.4809010284298566]]


phys3_avgs_300 = [[27.449863820000004, 32.951763199999995, 36.47647891333333, 40.74176479999999, 40.86320826, 41.11332323333333, 43.33137421333333, 44.49988194666668, 48.156346853333325, 54.05408176000001, 53.94393836666666, 53.87462926, 51.48421550666667, 53.01980189999999, 57.16541442, 54.311927746666676, 56.53832554, 59.619636019999994, 63.755607373333326, 57.995958173333335], [21.97283534, 24.49911776, 26.194678653333334, 28.718716939999997, 28.321568306666663, 28.538112440000003, 29.418966973333333, 30.234547733333333, 32.938206853333334, 35.42829726666667, 35.75500862, 35.753100413333335, 34.89313360666667, 36.152499600000006, 37.313092833333336, 37.228840500000004, 38.51274773333333, 40.39642097333333, 42.914437093333326, 39.55035704]]
phys3_std_errs_300 = [[0.7873104243662353, 0.9303874915176436, 1.2547975554915884, 1.9502342873354452, 1.2742379402533643, 1.7360959792729196, 1.5979655174931147, 1.273836567767026, 2.0165350522159806, 2.114044489491161, 2.1292763064097557, 2.7904889357702887, 3.1426199856982246, 2.0483497344718185, 3.1276030623690407, 1.4601246531742356, 2.1525363814072307, 2.9627748165256684, 1.7306299826211196, 1.417059695982177], [0.6945672711101434, 0.7879843941853065, 0.8663771758192402, 1.5349607213060863, 0.6730169798892324, 1.1358447831825755, 0.7793402349439559, 0.7410110326609985, 1.168498639956485, 0.9745387662977425, 1.0159097670249457, 1.3481058448595598, 1.6219781640056306, 1.170850885538937, 1.3546945197136764, 0.8514815716265668, 1.0417438931806822, 1.462238950815833, 0.9862463960425784, 0.7604371678936972]]

phys3_avgs_1000 = [[25.49465631753415, 30.78124455324406, 34.210325412480685, 35.98806984348949, 38.6982254047052, 41.49730139140805, 41.87537291068368, 41.599225554392135, 45.7113050952711, 47.006556328765484, 47.200461180728894, 50.50598175639815, 50.39805081528637, 50.43601550537399, 50.85270978822492, 51.94728546832272, 51.662646591355454, 54.54148805385707, 51.07332557402442, 51.64341464265429], [19.46378267487842, 22.3556317412882, 24.360166985026105, 25.10252713612374, 26.581902228925905, 28.136512041355616, 28.42901315281573, 28.26423370169964, 31.36880996194285, 31.867697071588054, 32.07642881906758, 34.869115058296124, 34.05474734500671, 34.11221015247485, 34.285734305093406, 35.0426865904638, 35.25765419579063, 36.923539516019176, 34.99111515388965, 35.448126595422366]]
phys3_std_errs_1000 = [[0.3034413671203378, 0.29113329014513756, 0.8736799576919199, 0.45571343509172274, 0.9443831843770938, 0.5547921692669695, 0.5870120310703937, 0.6187175363726426, 1.4182598229031225, 1.1379994091201475, 0.9737130069542661, 3.05932679791867, 1.5797269391439606, 1.229130385300334, 0.7932168965847207, 1.3452463772020125, 1.0336818813717612, 1.4906098462135207, 0.9336847924625092, 1.135681810855164], [0.25847275479457255, 0.2221840183291124, 0.7132547137528906, 0.3063786747274383, 0.5837931282500468, 0.32296059718529485, 0.37333834745670247, 0.32668383518811916, 1.3864287542525613, 0.8908870650803132, 0.7282124046315847, 2.9168828699214218, 1.1401439818524017, 0.6667653247982053, 0.3924535442632354, 0.7309035588546872, 0.6030520076686959, 0.9604134474139271, 0.478752647245101, 0.5952662561394254]]


vol_avgs = [phys1_avgs_1000[0], phys2_avgs_1000[0], phys3_avgs_1000[0]]
vol_std_errs = [phys1_std_errs_300[0], phys2_std_errs_1000[0], phys3_std_errs_1000[0]]


SA_avgs = [phys1_avgs_1000[1], phys2_avgs_1000[1], phys3_avgs_1000[1]]
SA_std_errs = [phys1_std_errs_1000[1], phys2_std_errs_1000[1], phys3_std_errs_1000[1]]

# Extract x values for plotting
x_values = list(lists.keys())

# Create traces for each line
trace_names = ['Devries', 'Renedive & Lemilch', 'Gal-Or & & Hoelsher']
traces = [go.Scatter(x=x_values, y=avg, mode='lines', name=trace_names[i], error_y=dict(type='data', array=vol_std_errs[i], visible=True)) for i, avg in enumerate(vol_avgs)]

# Create layout for the plot
layout = go.Layout(title=dict(text='AWVd_vs_Power1 for Volume % Difference - 1000 Balls', font=dict(size=50)),
                   xaxis=dict(title='Density', tickfont=dict(size=25), titlefont=dict(size=30)),
                   yaxis=dict(title='Percent Difference', tickfont=dict(size=25), titlefont=dict(size=30)),
                   legend=dict(font=dict(size=30)))

# Create figure
fig = go.Figure(data=traces, layout=layout)

# Show the plot
fig.show()